#define USEFOG

float4x4 viewProjMatrix : register (c0);
float4x4 worldMatrix : register (c4);
float4 worldEye : register (c8);
float4 fogData : register (c9);
float4 dirLight : register (c14);

#if OMNI == 1

float4 omniPosRad[12]   : register (c72);
float4 omniRGBDelta[12] : register (c84);

#elif SPOT == 1

float4 spotPosRad[4]    : register (c72);
float4 spotRGBDelta[4]  : register (c80);
float4 spotDirCone[4]   : register (c88);

#endif

struct VS_OUTPUT
{
   float4 Pos   : POSITION;
   float4 Diff  : COLOR0;
#if OMNI == 1 || SPOT == 1
   float4 Omni  : COLOR1;
#endif   
#ifdef USEFOG
   float  Fog   : FOG;
#endif   
   float2 Tex0  : TEXCOORD0;
   float2 Spec  : TEXCOORD1;
   float3 Norm  : TEXCOORD2;
   float3 Half  : TEXCOORD3;
};

#if OMNI == 1

 VS_OUTPUT vs11_blinnSpecMapOmniT0 (float4 inPos : POSITION, float4 inNorm : NORMAL, float4 inColor : COLOR0, float2 inTex : TEXCOORD0, float2 inSpec : TEXCOORD1)

#elif SPOT == 1

 VS_OUTPUT vs11_blinnSpecMapSpotT0 (float4 inPos : POSITION, float4 inNorm : NORMAL, float4 inColor : COLOR0, float2 inTex : TEXCOORD0, float2 inSpec : TEXCOORD1)
   
#else

 VS_OUTPUT vs11_blinnSpecMapT0 (float4 inPos : POSITION, float4 inNorm : NORMAL, float4 inColor : COLOR0, float2 inTex : TEXCOORD0, float2 inSpec : TEXCOORD1)
   
#endif
{
  VS_OUTPUT Out;
  
  // Transform vertex position into view space:
  Out.Pos = mul (viewProjMatrix, inPos);

  // Transform vertex normal into world space:
  float4 worldNorm = mul (worldMatrix, inNorm.xyz);
  Out.Norm = (worldNorm.xyz * 0.5) + 0.5;
  
  // compute halfway vector:
  float3 worldPos = mul (worldMatrix, inPos);
  float3 eyeVec =  worldEye.xyz + worldPos.xyz;
  float3 eyeVecN = normalize(eyeVec);
  Out.Half = (normalize (dirLight.xyz - eyeVecN.xyz));
  
#ifdef USEFOG
  // compute fog
  Out.Fog.x = (fogData[1] - (length (eyeVec.xyz) * fogData[0]));
#endif   
  
#if OMNI == 1
  // Compute omnilights
  Out.Omni = (0,0,0,0);
  Out.Omni.a = inColor.a;
  
  for (int i=0; i<6; i++)
  {
    float intens;
    float3 omniToVert = omniPosRad[i].xyz - worldPos.xyz;
    float mag = dot (omniToVert.xyz, omniToVert.xyz);
    // check if vert in range
    if ( mag < omniPosRad[i].w) // using square distances
      if ((intens = dot (worldNorm, normalize (omniToVert))) > 0) // check backface
        Out.Omni.rgb += (sqrt(intens) * omniRGBDelta[i].rgb * (1.0F - (sqrt(mag) * omniRGBDelta[i].w)));
  }
  Out.Omni.rgb *= 0.5F;
  
#elif SPOT == 1

  // Compute spotlights
  float4 spotColor = (0,0,0,1);
  //for (int i=0; i<numActive.y; i++)
  for (int i=0; i<4; i++)
  {
    // check backface
    if (dot (worldNorm, spotDirCone[i].xyz) <= 0)
    {
      float3 spotToVert = worldPos.xyz - spotPosRad[i].xyz;
      float mag = dot (spotToVert.xyz, spotToVert.xyz);
      // check if vert in range
      if (mag < spotPosRad[i].w) // using square distances
      {
        // check if vert in cone
        mag = dot (normalize (spotToVert.xyz), spotDirCone[i].xyz);
        if (mag > spotDirCone[i].w)
        {
          float intensity = (1.0F - ( sqrt (mag) * spotRGBDelta[i].w));
          spotColor.rgb += (spotRGBDelta[i].rgb * intensity);
        }  
      }
    }
  }
  Out.Omni = spotColor;

#endif

  // Propagate color and texture coordinates:
  Out.Diff = inColor;
  Out.Tex0 = inTex;
  Out.Spec = inSpec;

  return (Out);
}


